function [bML, A, covML, fitML, forML, Stats]= ...
                                bda(y, X, Xfor, var, output, Xlabel)
%BDA      Bayesian Discriminant Analysis Model Estimation.
%          [bML, A, covML, fitML, forML]= ...
%                          bda(y, X, Xfor, var, output, Xlabel)
%
% bML: Estimated Maximum Likelihood beta parameters.
% A: 
% covML: Covariance of beta estimated parameters.
% fitML: Fitted values.
% forML: forecast values.
%
% y: Binary output variable.
% X: Input variables.
% Xfor: Input variables for new elements in the sample (not in X).
% var: Same or different variance for both groups (1/0).
% output: Show tabular output on/off (1/0).
% Xlabel: Variable names for the inputs.

% BUGS: covML no es correcta para matriz A cuando las varianzas no son iguales
%      y: Binary endogenous variable.
%      X: Exogenous variables (If constant included, it should be the first column of X)
%      var: Same variance for both groups (=1) or different (=0)
%      out: Tabular and graphical output on/off.

%	(c) Diego Pedregal. Jan - 1998
